import { world, system, ItemStack, BlockPermutation, EquipmentSlot, TicksPerSecond } from '@minecraft/server'

world.afterEvents.playerBreakBlock.subscribe((data) => {
    const block = data.block
    const { x, y, z } = block.location
    const blockPerm = data.brokenBlockPermutation.type.id
    const player = data.player
    const itemIron = data.dimension.getEntities({ type: 'minecraft:item', name: 'Raw Iron', closest: 1 })
    const itemCopper = data.dimension.getEntities({ type: 'minecraft:item', name: 'Raw Copper', closest: 1 })
    const itemGold = data.dimension.getEntities({ type: 'minecraft:item', name: 'Raw Gold', closest: 1 })
    const itemTin = data.dimension.getEntities({ type: 'minecraft:item', name: 'Raw Tin', closest: 1 })
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const ironIngot = new ItemStack('minecraft:iron_ingot', 1)
    const goldIngot = new ItemStack('minecraft:gold_ingot', 1)
    const copperIngot = new ItemStack('minecraft:copper_ingot', 4)
    const tinIngot = new ItemStack('v360:tin_ingot', 1)
    if ((selectedItem?.typeId === 'v360:jade_crusher_pickaxe' || selectedItem?.typeId === 'v360:citrine_crusher_pickaxe' || selectedItem?.typeId === 'v360:amethyst_crusher_pickaxe' || selectedItem?.typeId === 'v360:garnet_crusher_pickaxe') && player.getGameMode() !== 'creative' && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
        if (blockPerm === 'minecraft:iron_ore' || blockPerm === 'minecraft:deepslate_iron_ore') {
            itemIron[0].kill()
            system.run(() => {
                data.dimension.spawnItem(ironIngot, { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
            })
            block.dimension.runCommand(`particle v360:crusher_pickaxe ${x} ${y + 0.5} ${z}`)
            block.dimension.playSound('random.fizz', block.location)
        }
        else if (blockPerm === 'minecraft:copper_ore' || blockPerm === 'minecraft:deepslate_copper_ore') {
            itemCopper[0].kill()
            system.run(() => {
                data.dimension.spawnItem(copperIngot, { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
            })
            block.dimension.runCommand(`particle v360:crusher_pickaxe ${x} ${y + 0.5} ${z}`)
            block.dimension.playSound('random.fizz', block.location)
        }
        else if (blockPerm === 'minecraft:gold_ore' || blockPerm === 'minecraft:deepslate_gold_ore') {
            itemGold[0].kill()
            system.run(() => {
                data.dimension.spawnItem(goldIngot, { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
            })
            block.dimension.runCommand(`particle v360:crusher_pickaxe ${x} ${y + 0.5} ${z}`)
            block.dimension.playSound('random.fizz', block.location)
        }
        else if (blockPerm === 'v360:tin_ore' || blockPerm === 'v360:deepslate_tin_ore') {
            itemTin[0].kill()
            system.run(() => {
                data.dimension.spawnItem(tinIngot, { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
            })
            block.dimension.runCommand(`particle v360:crusher_pickaxe ${x} ${y + 0.5} ${z}`)
            block.dimension.playSound('random.fizz', block.location)
        }
    }
})

world.beforeEvents.playerBreakBlock.subscribe((data) => {
    const block = data.block
    const { x, y, z } = block.location
    const player = data.player
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    if (selectedItem?.typeId === 'v360:jade_crusher_pickaxe' && Math.random() <= 0.70) {
        if ((block.typeId === 'minecraft:stone' || block.typeId === 'minecraft:deepslate' || block.typeId === 'minecraft:andesite' || block.typeId === 'minecraft:granite' || block.typeId === 'minecraft:diorite' || block.typeId === 'minecraft:tuff' || block.typeId === 'v360:amphibolite' || block.typeId === 'minecraft:calcite' || block.typeId === 'minecraft:dripstone' || block.typeId === 'v360:rootstone' || block.typeId === 'v360:limestone') && player.getGameMode() !== 'creative') {
            system.run(() => {
                block.dimension.runCommand(`loot spawn ${x} ${y} ${z} loot crusher_pickaxe`)
            })
        }
    }
})

system.runInterval(() => {
    world.getAllPlayers().filter(
        (data) => {
            const selectedItem = data.getComponent('equippable')
            if (selectedItem.getEquipment(EquipmentSlot.Mainhand)?.typeId === 'v360:citrine_crusher_pickaxe') {
                data.addEffect("haste", TicksPerSecond * 1, { amplifier: 1, showParticles: false })
            }
        }
    )
})

world.beforeEvents.playerBreakBlock.subscribe((data) => {
    const player = data.player
    const block = data.block
    const { x, y, z } = block.location
    const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
    const chance = Math.random()
    if (selectedItem?.typeId === 'v360:amethyst_crusher_pickaxe' && player.getGameMode() !== 'creative') {
        if (chance < 0.50) {
            if (block.typeId === 'minecraft:stone' && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:cobblestone'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:stone' && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:stone'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:deepslate' && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:cobbled_deepslate'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:deepslate' && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:deepslate'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:granite') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:granite'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:diorite') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:diorite'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:andesite') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:andesite'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:tuff') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:tuff'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'minecraft:calcite') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:calcite'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'v360:amphibolite') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('v360:amphibolite'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'v360:rootstone') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('v360:rootstone'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if (block.typeId === 'v360:limestone') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('v360:limestone'), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if ((block.typeId === 'minecraft:coal_ore' || block.typeId === 'minecraft:deepslate_coal_ore') && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:coal', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if ((block.typeId === 'minecraft:iron_ore' || block.typeId === 'minecraft:deepslate_iron_ore') && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:iron_ingot', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if ((block.typeId === 'minecraft:gold_ore' || block.typeId === 'minecraft:deepslate_gold_ore') && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:gold_ingot', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if ((block.typeId === 'minecraft:emerald_ore' || block.typeId === 'minecraft:deepslate_emerald_ore') && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:emerald', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if ((block.typeId === 'minecraft:diamond_ore' || block.typeId === 'minecraft:deepslate_diamond_ore') && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('minecraft:diamond', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
            else if ((block.typeId === 'v360:tin_ore' || block.typeId === 'v360:deepslate_tin_ore') && !selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('v360:tin_ingot', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
        }
    }
})